(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16482,        419]
NotebookOptionsPosition[     15362,        379]
NotebookOutlinePosition[     15779,        395]
CellTagsIndexPosition[     15736,        392]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 1", "Title",
 Editable->False,
 CellChangeTimes->{{3.410866027499008*^9, 3.4108660292815714`*^9}}],

Cell["Introduction", "Subtitle",
 Editable->False,
 CellChangeTimes->{{3.41086703149268*^9, 3.4108670334054303`*^9}, {
  3.410867080543211*^9, 3.4108670921298723`*^9}}],

Cell["\[Copyright]W.W.Sampson, Manchester, 2008", "Subsubtitle",
 Editable->False,
 CellChangeTimes->{{3.412935407213834*^9, 3.412935418490048*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "1.3 Modelling with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "Section",
 CellChangeTimes->{{3.410866033758008*^9, 3.4108660509727616`*^9}}],

Cell[TextData[{
 "To carry out integrals, we use the command, ",
 StyleBox["Integrate", "Input"],
 ". An example of an integral that is more difficult than it appears on \
initial inspection is\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", "x"], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
  "InlineFormula"],
 "\n\nWe input this to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        StyleBox["x",
         FontSlant->"Plain"]], "/", 
       StyleBox["x",
        FontSlant->"Plain"]}], ",", " ", 
      StyleBox["x",
       FontSlant->"Plain"]}], "]"}],
    FontFamily->"Courier New",
    FontWeight->"Bold"], TraditionalForm]]],
 "; the character \[ExponentialE] is obtained by doing \[EscapeKey] ",
 StyleBox["ee",
  FontFamily->"Courier New",
  FontWeight->"Bold"],
 "\[EscapeKey]. We evaluate the input by pressing \[ShiftKey] and \[EnterKey] \
together:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4108660921019025`*^9, 3.4108662293091965`*^9}, {
  3.410866273232355*^9, 3.4108665005392065`*^9}, {3.4108671303448224`*^9, 
  3.410867162410931*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], "/", "x"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.383905226164873*^9, 3.383905238789873*^9}, {
   3.383905748914873*^9, 3.383905751758623*^9}, {3.383907136696123*^9, 
   3.383907170977373*^9}, 3.383908289242998*^9, {3.4108674354134893`*^9, 
   3.4108674370658655`*^9}}],

Cell[BoxData[
 RowBox[{"ExpIntegralEi", "[", "x", "]"}]], "Output",
 CellChangeTimes->{{3.383907146836748*^9, 3.383907171414873*^9}, {
   3.383908290399248*^9, 3.383908317164873*^9}, 3.383911016671875*^9, 
   3.383913509859375*^9, 3.383914291859375*^9, 3.4047209785115*^9, 
   3.404725584324*^9, 3.4108637407207823`*^9}]
}, Open  ]],

Cell[TextData[{
 "A plot of the function is obtained using the command ",
 StyleBox["Plot", "Input"],
 ", where the first argument gives the function we want to plot and the \
second argument specifies the range of the independent variable over which to \
plot the function:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4108665528644466`*^9, 3.4108666402701297`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ExpIntegralEi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.383906921430498*^9, 3.383906950086748*^9}, 
   3.383907860539873*^9, {3.383908156789873*^9, 3.383908184633623*^9}, {
   3.4108637436249585`*^9, 3.410863765927027*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2Hc41e//B3B7ZyapCJUQIhKp7qMkKUKLFJFRRvkUIUIoq6wys0fZK8pB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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-2, 2}, {-7.5083443068791365`, 4.95423405440777}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.383906936555498*^9, 3.383906950430498*^9}, {
   3.383908157711748*^9, 3.383908184992998*^9}, {3.383908300274248*^9, 
   3.383908317289873*^9}, 3.383911017328125*^9, 3.38391351003125*^9, 
   3.383914292328125*^9, 3.404721480089625*^9, 3.40472562298025*^9, 
   3.410863767579403*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " accepts a range of input forms. Here we specify our integral using three \
equivalent forms:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4108666741588593`*^9, 3.4108667643986177`*^9}}],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "/", "x"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.383910896765625*^9, 3.38391097440625*^9}, {
   3.404721517714625*^9, 3.404721584714625*^9}, 3.4047216158865*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "x"], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.383910896765625*^9, 3.38391097440625*^9}, {
  3.404721517714625*^9, 3.404721584714625*^9}, {3.4047216158865*^9, 
  3.404721618839625*^9}}],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", "x"}], "/", "x"}], ",", " ", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.383910896765625*^9, 3.38391097440625*^9}, {
  3.404721517714625*^9, 3.404721584714625*^9}, {3.4047216158865*^9, 
  3.404721618839625*^9}}],

Cell[TextData[{
 "We can manipulate many ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects interactively. In the following example, we use ",
 StyleBox["Manipulate", "Input"],
 " to generate an object where we may vary the value of ",
 StyleBox["x",
  FontSlant->"Italic"],
 " to test the range for which the approximation ",
 StyleBox["x",
  FontSlant->"Italic"],
 " \[TildeTilde] sin(",
 StyleBox["x",
  FontSlant->"Italic"],
 ") is reasonable. Moving the slider in the resultant manipulate object \
varies x and sin(",
 StyleBox["x",
  FontSlant->"Italic"],
 ")/",
 StyleBox["x",
  FontSlant->"Italic"],
 " in real time:"
}], "Text",
 Editable->False,
 CellChangeTimes->{{3.4108667773672657`*^9, 3.4108669852461805`*^9}, 
   3.410867025443982*^9, {3.4108672651686897`*^9, 3.410867265799597*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "/", "x"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1."}], "}"}], ",", " ", "0", ",", " ", "\[Pi]"}], 
    "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.38391340415625*^9, 3.383913439859375*^9}, {
  3.383914247828125*^9, 3.383914252796875*^9}, {3.404722584839625*^9, 
  3.404722584933375*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 2.6640705702441445`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`x$$], 1.}, 0, Pi}}, Typeset`size$$ = {
    123.1875, {2., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$456$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 1.}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$456$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, Sin[$CellContext`x$$]/$CellContext`x$$}, 
      "Specifications" :> {{{$CellContext`x$$, 1.}, 0, Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{247., {47., 52.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.383913409921875*^9, 3.38391344034375*^9}, 
   3.383913510203125*^9, {3.383914253484375*^9, 3.38391429259375*^9}, {
   3.4047225857615*^9, 3.4047226115115*^9}, 3.40472565823025*^9, 
   3.4108637769628963`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{616, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 112, 2, 73, "Title"],
Cell[705, 27, 168, 3, 36, "Subtitle"],
Cell[876, 32, 148, 2, 29, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1049, 38, 176, 6, 75, "Section"],
Cell[1228, 46, 1332, 42, 147, "Text"],
Cell[CellGroupData[{
Cell[2585, 92, 399, 9, 41, "Input"],
Cell[2987, 103, 320, 5, 40, "Output"]
}, Open  ]],
Cell[3322, 111, 375, 8, 66, "Text"],
Cell[CellGroupData[{
Cell[3722, 123, 396, 9, 41, "Input"],
Cell[4121, 134, 6925, 119, 248, "Output"]
}, Open  ]],
Cell[11061, 256, 261, 7, 47, "Text"],
Cell[11325, 265, 284, 7, 41, "Input"],
Cell[11612, 274, 329, 8, 56, "Input"],
Cell[11944, 284, 300, 7, 41, "Input"],
Cell[12247, 293, 811, 26, 84, "Text"],
Cell[CellGroupData[{
Cell[13083, 323, 495, 14, 41, "Input"],
Cell[13581, 339, 1741, 35, 126, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

